#####################################
# CSFD Lite by mik9
#####################################
soucasnaverze = 0.97


# -*- coding: UTF-8 -*-
from Plugins.Plugin import PluginDescriptor
from twisted.web.client import downloadPage
from enigma import ePicLoad, eServiceReference, eServiceCenter, getDesktop, iServiceInformation, eConsoleAppContainer
from Screens.Screen import Screen
from Screens.EpgSelection import EPGSelection
from Screens.ChannelSelection import SimpleChannelSelection
from Screens.MessageBox import MessageBox
from Components.ActionMap import ActionMap
from Components.Pixmap import Pixmap
from Components.Label import Label
from Components.ScrollLabel import ScrollLabel
from Components.Button import Button
from Components.AVSwitch import AVSwitch
from Components.MenuList import MenuList
from Components.ProgressBar import ProgressBar
from Tools.Directories import resolveFilename, SCOPE_PLUGINS, SCOPE_SKIN_IMAGE
from os import environ as os_environ
import re
import htmlentitydefs
import urllib, urllib2
import gettext
from random import *
import sys
from os import path, access, R_OK, remove
import time



class CSFDChannelSelection(SimpleChannelSelection):
	def __init__(self, session):
		SimpleChannelSelection.__init__(self, session, "Volba kan\xc3\xa1lu")
		self.skinName = "SimpleChannelSelection"

		self["ChannelSelectEPGActions"] = ActionMap(["ChannelSelectEPGActions"],
			{
				"showEPGList": self.channelSelected
			}
		)


	def channelSelected(self):
		ref = self.getCurrentSelection()
		if (ref.flags & 7) == 7:
			self.enterPath(ref)
		elif not (ref.flags & eServiceReference.isMarker):
			self.session.openWithCallback(
				self.epgClosed,
				CSFDEPGSelection,
				ref,
				openPlugin = False
			)


	def epgClosed(self, ret = None, popis = ""):
		if ret:
			self.close(ret, popis)


class CSFDEPGSelection(EPGSelection):
	def __init__(self, session, ref, openPlugin = True):
		EPGSelection.__init__(self, session, ref)
		self.skinName = "EPGSelection"
		self["key_green"].setText("Hled\xc3\xa1n\xc3\xad")
		self.openPlugin = openPlugin


	def infoKeyPressed(self):
		self.timerAdd()


	def timerAdd(self):
		cur = self["list"].getCurrent()
		evt = cur[0]
		self.popiskomplet = evt.getShortDescription() + "\n" + evt.getExtendedDescription()
		sref = cur[1]
		if not evt: 
			return

		if self.openPlugin:
			self.session.open(
				CSFDLite,
				evt.getEventName(),
				self.popiskomplet
			)
		else:
			self.close(evt.getEventName(),self.popiskomplet)


	def onSelectionChanged(self):
		pass


class CSFDLite(Screen):
	def __init__(self, session, eventName, predanypopis='', args=None):
		self.sirkadispleje = getDesktop(0).size().width()
		if getDesktop(0).size().width() > 1800:
			self.skinfile = "/usr/lib/enigma2/python/Plugins/Extensions/CSFDLite/skinFullHD.xml"
			self.omezenikomentaru = 25000
			self.omezeninazvu = 100
		else:
			self.skinfile = "/usr/lib/enigma2/python/Plugins/Extensions/CSFDLite/skinHD.xml"
			self.omezenikomentaru = 19000
			self.omezeninazvu = 70
		skinsoubor = open(self.skinfile)
		self.skin = skinsoubor.read()
		skinsoubor.close()
		Screen.__init__(self, session)
		self.eventName = eventName
		self.predanypopis = predanypopis
		self["poster"] = Pixmap()
		self.picload = ePicLoad()
		self.picload.PictureData.get().append(self.paintPosterPixmapCB)
		self["stars"] = ProgressBar()
		self["starsbg"] = Pixmap()
		self["stars"].hide()
		self["starsbg"].hide()
		self.ratingstars = -1
		self["titlelabel"] = Label("CSFD Lite")
		self["detailslabel"] = ScrollLabel("")
		self["extralabel"] = ScrollLabel("")
		self["statusbar"] = Label("")
		self["ratinglabel"] = Label("")
		self.resultlist = []
		self["menu"] = MenuList(self.resultlist)
		self["menu"].hide()
		self["key_red"] = Button("Exit")
		self["key_green"] = Button("")
		self["key_yellow"] = Button("")
		self["key_blue"] = Button("")
		# 0 = multiple query selection menu page
		# 1 = movie info page
		# 2 = extra infos page
		self.Page = 0
		self["actions"] = ActionMap(["CSFDLiteActions"],
		{
			"okLite": self.showDetails,
			"cancelLite": self.close,
			"downLite": self.pageDown,
			"upLite": self.pageUp,
			"rightLite": self.vpravo,
			"leftLite": self.vlevo,
			"redLite": self.close,
			"greenLite": self.showMenu,
			"yellowLite": self.showDetails,
			"blueLite": self.showExtras,
			"contextMenuLite": self.openChannelSelection,
			"showEventInfoLite": self.showDetails
		}, -1)
		try:
			self.container = eConsoleAppContainer()
			self.container.appClosed.append(self.konecExekuce)
			self.kontejnerfunguje = True
		except:
			self.kontejnerfunguje = False
		self.getCSFD()


	def najdi(self, retezec, celytext):
		maska = re.compile(retezec, re.DOTALL)
		vysledek = maska.findall(celytext)
		vysledek = vysledek[0] if vysledek else ""
		return vysledek

	def hledejVse(self, retezec, celytext):
		maska = re.compile(retezec, re.DOTALL)
		vysledky = maska.findall(celytext)
		return vysledky


	def odstraneniTagu(self, upravovanytext):
		self.htmltags = re.compile('<.*?>')
		upravovanytext = self.htmltags.sub('', upravovanytext)
		upravovanytext = upravovanytext.replace('&amp;', '&').replace('&nbsp;', ' ')
		return upravovanytext


	def odstraneniZbytecnosti(self, upravovanytext):
		zbytecnosti = [" -HD", " -W", " -ST", " -AD"]
		for zbytecnost in zbytecnosti:
			upravovanytext = upravovanytext.replace(zbytecnost, '')
		serialy = self.najdi('(\s+[IVX]{0,7}.?\s?\([0-9]?[0-9]?[0-9],?\s?[0-9]?[0-9]?[0-9]?\))', upravovanytext)
		upravovanytext = upravovanytext.replace(serialy, '')
		casti = self.najdi('(\s+\(?[0-9]?[0-9]?[0-9]/[0-9]?[0-9]?[0-9]\)?)(?![0-9])', upravovanytext)
		upravovanytext = upravovanytext.replace(casti, '')
		return upravovanytext
		

	def odstraneniInterpunkce(self, upravovanytext):
		interpunkce = ',<.>/?;:"[{]}`~!@#$%^&*()-_=+|'
		for znak in interpunkce:
			upravovanytext = upravovanytext.replace(znak, ' ')
		upravovanytext = upravovanytext.replace('   ', ' ').replace('  ', ' ')
		return upravovanytext


	def malaPismena(self, upravovanytext):
		velka = ['\\xc3\\x81','\\xc4\\x8c','\\xc4\\x8e','\\xc3\\x89','\\xc4\\x9a','\\xc3\\x8d','\\xc5\\x87','\\xc3\\x93','\\xc5\\x98','\\xc5\\xa0','\\xc5\\xa4','\\xc3\\x9a','\\xc5\\xae','\\xc3\\x9d','\\xc5\\xbd']
		mala =  ['\\xc3\\xa1','\\xc4\\x8d','\\xc4\\x8f','\\xc3\\xa9','\\xc4\\x9b','\\xc3\\xad','\\xc5\\x88','\\xc3\\xb3','\\xc5\\x99','\\xc5\\xa1','\\xc5\\xa5','\\xc3\\xba','\\xc5\\xaf','\\xc3\\xbd','\\xc5\\xbe']
		for velky, maly in zip(velka, mala):
			upravovanytext = upravovanytext.replace(velky, maly)
		upravovanytext = upravovanytext.lower()
		return upravovanytext


	def adresaPredPresmerovanim(self, adresa):
		opener = urllib2.build_opener(urllib2.HTTPRedirectHandler)
		request = opener.open(adresa)
		return request.url


	def nactiKomentare(self, predanastranka):
		vyslednytext = ""
		komentare = self.najdi('<h2>Koment(.*?)<div class="footer">', predanastranka)
		for jedenkomentar in self.hledejVse('<h5 class="author"(.*?)/span>', komentare):
			autorkomentare = self.najdi('>(.*?)</h5>', jedenkomentar)
			if "a href" in autorkomentare:
				autorkomentare = self.najdi('>(.*?)<', autorkomentare)
			hodnocenikomentare = self.najdi('class="rating"(.*?)<p class="post">', jedenkomentar)
			if "alt=" in hodnocenikomentare:
				hodnocenikomentare = self.najdi('alt="(.*?)"', hodnocenikomentare)
			elif "odpad" in hodnocenikomentare:
				hodnocenikomentare = "odpad!"
			else:
				hodnocenikomentare = ""
			komentar = self.najdi('class="post">(.*?)<span', jedenkomentar)
			datumkomentare = self.najdi('class="date desc">(.*?)<', jedenkomentar)
			vyslednytext += autorkomentare + '    ' + hodnocenikomentare + '\n' + komentar + '\n' + datumkomentare + '\n\n'
		return vyslednytext


	def fetchFailed(self, string):
		print "[CSFD] fetch failed "
		self["statusbar"].setText("Selhalo stahov\xc3\xa1n\xc3\xad z CSFD")


	def resetLabels(self):
		self["detailslabel"].setText("")
		self["ratinglabel"].setText("")
		self["titlelabel"].setText("")
		self["extralabel"].setText("")
		self.ratingstars = -1


	def pageUp(self):
		if self.Page == 0:
			self["menu"].instance.moveSelection(self["menu"].instance.moveUp)
		if self.Page == 1:
			self["detailslabel"].pageUp()
		if self.Page == 2:
			self["extralabel"].pageUp()
	

	def pageDown(self):
		if self.Page == 0:
			self["menu"].instance.moveSelection(self["menu"].instance.moveDown)
		if self.Page == 1:
			self["detailslabel"].pageDown()
		if self.Page == 2:
			self["extralabel"].pageDown()


	def vlevo(self):
		if self.Page == 0:
			self["menu"].instance.moveSelection(self["menu"].instance.pageUp)
		if self.Page == 1:
			self["detailslabel"].pageUp()
		if self.Page == 2:
			self["extralabel"].pageUp()


	def vpravo(self):
		if self.Page == 0:
			self["menu"].instance.moveSelection(self["menu"].instance.pageDown)
		if self.Page == 1:
			self["detailslabel"].pageDown()
		if self.Page == 2:
			self["extralabel"].pageDown()


	def showMenu(self):
		if ( self.Page is 1 or self.Page is 2 ) and self.resultlist:
			hlavicka = self.nazeveventuproskin
			if self.rokEPG != '':
				hlavicka += ' (' + self.rokEPG + ')'	
			self.setTitle("V\xc3\xbdsledky hled\xc3\xa1n\xc3\xad pro " + hlavicka + " - CSFD Lite v. " + str(soucasnaverze))
			self["menu"].show()
			self["stars"].hide()
			self["starsbg"].hide()
			self["ratinglabel"].hide()
			self["poster"].hide()
			self["extralabel"].hide()
			self["titlelabel"].hide()
			self["detailslabel"].hide()
			self["key_blue"].setText("")
			self["key_green"].setText("Seznam")
			self["key_yellow"].setText("Info o filmu")
			self.Page = 0
			

	def showDetails(self):
		self["ratinglabel"].show()
		self["detailslabel"].show()

		if self.resultlist and self.Page == 0:
			if not self.unikatni:
				self.link = self["menu"].getCurrent()[1]
				self.nazevkomplet = self["menu"].getCurrent()[0]
			self.unikatni = False
			self["statusbar"].setText("Stahov\xc3\xa1n\xc3\xad informace o filmu v CSFD: %s" % (self.link))
			localfile = "/tmp/CSFDquery2.html"
			fetchurl = "https://www.csfd.cz/film/" + self.link + "/komentare/?" + str(randint(1000, 9999))
			print "[CSFD] downloading query " + fetchurl + " to " + localfile
			downloadPage(fetchurl,localfile).addCallback(self.CSFDquery2).addErrback(self.fetchFailed)
			self["menu"].hide()
			self.resetLabels()
			self.setTitle(self.nazevkomplet + " - CSFD Lite v. " + str(soucasnaverze))
			self["titlelabel"].show()
			self.Page = 1

		if self.Page == 2:
			self["titlelabel"].show()
			self["extralabel"].hide()
			self["poster"].show()
			if self.ratingstars > 0:
				self["starsbg"].show()
				self["stars"].show()
				self["stars"].setValue(self.ratingstars)

			self.Page = 1


	def showExtras(self):
		if self.Page == 1:
			self["extralabel"].show()
			self["detailslabel"].hide()
			self["poster"].hide()
			self["stars"].hide()
			self["starsbg"].hide()
			self["ratinglabel"].hide()
			self.Page = 2


	def openChannelSelection(self):
		self.session.openWithCallback(
			self.channelSelectionClosed,
			CSFDChannelSelection
		)


	def channelSelectionClosed(self, ret = None, popis = ""):
		if ret:
			self.eventName = ret
			self.predanypopis = popis
			self.Page = 0
			self.resultlist = []
			self["menu"].hide()
			self["ratinglabel"].show()
			self["detailslabel"].show()
			self["poster"].hide()
			self["stars"].hide()
			self["starsbg"].hide()
			self.getCSFD()


	def getCSFD(self):
		self.resetLabels()
		self.popisEPG = self.predanypopis
		if self.eventName is "":
			s = self.session.nav.getCurrentService()
			info = s and s.info()
			event = info and info.getEvent(0) # 0 = now, 1 = next
			self.popisEPG = ""
			if event:
				self.eventName = event.getEventName()
				self.popisEPG = event.getShortDescription() + "\n" + event.getExtendedDescription()

		if self.popisEPG:
			self.rokEPG = self.najdi('([0-9]{4})', self.popisEPG)
			if self.rokEPG == '':
				self.rokEPG = self.najdi('[0-9]{4}', self.popisEPG)
		else:
			self.rokEPG = ''

		if self.eventName is not "":
			self.eventName = self.odstraneniZbytecnosti(self.eventName)
			self.nazeveventuproskin = self.eventName
			try:
				self.eventName = urllib.quote(self.eventName)
			except:
				self.eventName = urllib.quote(self.eventName.decode('utf8').encode('ascii','ignore'))

			self.nazeveventu = self.eventName
			jineznaky = list(set(self.hledejVse('(%[0-9A-F][0-9A-F])', self.nazeveventu)))
			for jinyznak in jineznaky:
				desitkove = int(jinyznak[1:3], 16)
				if desitkove > 31 and desitkove < 128:
					self.nazeveventu = self.nazeveventu.replace(jinyznak, chr(desitkove)) 
				elif desitkove > 127:
					self.nazeveventu = self.nazeveventu.replace(jinyznak, jinyznak.lower())
			self.nazeveventu = self.nazeveventu.replace('%', '\\x')

			self["statusbar"].setText("Hled\xc3\xa1n\xc3\xad v CSFD pro: %s" % (self.nazeveventuproskin))
			localfile = "/tmp/CSFDquery.html"
			fetchurl = "https://www.csfd.cz/hledat/?q=" + self.eventName
			self.puvodniurl = fetchurl
			print "[CSFD] Downloading Query " + fetchurl + " to " + localfile
			downloadPage(fetchurl,localfile).addCallback(self.CSFDquery).addErrback(self.fetchFailed)
		else:
			self["statusbar"].setText("Nejde z\xc3\xadskat Eventname")


	def CSFDquery(self, string):
		print "[CSFDquery]"
		self["statusbar"].setText("Stahov\xc3\xa1n\xc3\xad z CSFD dokon\xc4\x8deno pro %s" % (self.nazeveventuproskin))
		self.inhtml = (open("/tmp/CSFDquery.html", "r").read())
		self.resultlist = []
		self.unikatni = False

		if '<h1 itemprop="name">' in self.inhtml:
			odkaz = self.najdi('<link rel="canonical" href="https://www.csfd.cz/film/(.*?)/', self.inhtml)
			nazevfilmu = self.najdi('<h1 itemprop="name">\s+(.*?)\s+<', self.inhtml)
			self.resultlist = [(nazevfilmu, odkaz)]
		elif not "<!DOCTYPE html" in self.inhtml:
			odkaz = self.adresaPredPresmerovanim(self.puvodniurl)
			odkaz = self.najdi('https://www.csfd.cz/film/(.*?)/', odkaz)
			self.resultlist = [(self.nazeveventuproskin, odkaz)]
		elif "SFD.cz</title>" in self.inhtml:
			print "[CSFD] ziskavani seznamu"
			filmy = self.najdi('<h2 class="header">Filmy</h2>(.*?)</ul>', self.inhtml)
			self.resultlist = []
			for odkaz, filmnazev, filminfo in self.hledejVse('<h3 class="subject"><a href="/film/(.*?)"(.*?)</h3>.*?<p>(.*?)</p>', filmy):
				hlavninazev = self.najdi('class="film c[0-9]">(.*?)</a>', filmnazev)
				celynazev = hlavninazev
				if 'class="film-type"' in filmnazev:
					typnazev = self.najdi('<span class="film-type">(.*?)</span>', filmnazev)
					celynazev += ' ' + typnazev
				celynazev += ' (' + filminfo + ')'
				rok = self.najdi('([0-9]{4})', filminfo)
				self.resultlist += [(celynazev, odkaz, hlavninazev, rok)]
			
			filmy = self.najdi('<ul class="films others">(.*?)</ul>', self.inhtml)
			for odkaz, filmnazev, filminfo in self.hledejVse('<a href="/film/(.*?)"(.*?)dir="ltr">(.*?)</span>', filmy):
				hlavninazev = self.najdi('class="film c[0-9]">(.*?)</a>', filmnazev)
				celynazev = hlavninazev
				if 'class="film-type"' in filmnazev:
					typnazev = self.najdi('<span class="film-type">(.*?)</span>', filmnazev)
					celynazev += ' ' + typnazev
				celynazev += ' ' + filminfo
				rok = self.najdi('([0-9]{4})', filminfo)
				self.resultlist += [(celynazev, odkaz, hlavninazev, rok)]

			shoda = []
			for nazevinfo, odkaz, nazevfilmu, rok in self.resultlist:
				konvertovanynazev = ""
				nazevfilmu = self.odstraneniTagu(nazevfilmu)
				for znak in nazevfilmu:
					if ord(znak) > 127:
						znak = "\\x" + znak.encode("hex")
					konvertovanynazev += znak
				if self.malaPismena(self.odstraneniInterpunkce(konvertovanynazev)) == self.malaPismena(self.odstraneniInterpunkce(self.nazeveventu)):
					shoda += [(self.odstraneniTagu(nazevinfo), odkaz, rok)]
			if len(shoda) == 1:
				self.nazevkomplet, self.link, v3 = shoda[0]
				self.unikatni = True
			elif len(shoda) > 1:
				for nazevinfo, odkaz, rok in shoda:
					if self.rokEPG == rok and not self.unikatni:
						self.nazevkomplet, self.link, v3 = self.odstraneniTagu(nazevinfo), odkaz, rok
						self.unikatni = True
			self.resultlist = [(v1, v2) for v1, v2, v3, v4 in self.resultlist]
		else:
			self["detailslabel"].setText("Dotaz na CSFD nebyl \xc3\xbasp\xc4\x9b\xc5\xa1n\xc3\xbd")

		if self.resultlist:
			self.resultlist = [(self.odstraneniTagu(nazevinfo), odkaz) for nazevinfo, odkaz in self.resultlist]
			self["menu"].l.setList(self.resultlist)
			self['menu'].moveToIndex(0)
			if len(self.resultlist) == 1 or self.unikatni:
				self.Page = 1
				self.showMenu()
				self.Page = 0
				self["extralabel"].hide()
				self.showDetails()
			elif len(self.resultlist) > 1:
				self.Page = 1
				self.showMenu()
		else:
			self["detailslabel"].setText("Nenalezena informace v CSFD pro %s" % (self.nazeveventuproskin))
			self["statusbar"].setText("Nenalezena informace v CSFD pro %s" % (self.nazeveventuproskin))
		self.kontrolaUpdate()


	def CSFDquery2(self, string):
		self["statusbar"].setText("Stahov\xc3\xa1n\xc3\xad informace o filmu dokon\xc4\x8deno pro:  %s" % (self.nazevkomplet))
		self.inhtml = (open("/tmp/CSFDquery2.html", "r").read())
		if 'DOCTYPE html PUBLIC' in self.inhtml:
			self.CSFDparse()
		else:
			self["statusbar"].setText("Problem pri na\xc4\x8d\xc3\xadt\xc3\xa1n\xc3\xad: %s" % (self.link))


	def CSFDquery3(self, string):
		self.inhtml2 = (open("/tmp/CSFDquery3.html", "r").read())
		if 'DOCTYPE html PUBLIC' in self.inhtml2:
			self.komentare2 += self.nactiKomentare(self.inhtml2)
		else:
			self["statusbar"].setText("Problem pri na\xc4\x8d\xc3\xadt\xc3\xa1n\xc3\xad: %s" % (self.link2))
		self.zobrazKomentare(self.komentare2)


	def zobrazKomentare(self, vsechnykomentare):
		if vsechnykomentare != "":
			vsechnykomentare = self.odstraneniTagu(vsechnykomentare)
			if len(vsechnykomentare) > self.omezenikomentaru:
				vsechnykomentare = vsechnykomentare[0:self.omezenikomentaru] + "...\n\n(seznam koment\xc3\xa1\xc5\x99\xc5\xaf zkr\xc3\xa1cen)"
			self["extralabel"].setText(vsechnykomentare)
			self["extralabel"].hide()
			self["key_blue"].setText("Koment\xc3\xa1\xc5\x99e")		


	def CSFDparse(self):
		print "[CSFDparse]"
		self.Page = 1
		Detailstext = "Nenalezeny informace o filmu"
		if '<h1 itemprop="name">' in self.inhtml:
			self["key_yellow"].setText("Info o filmu")
			self["statusbar"].setText("Info o filmu z CSFD z\xc3\xadsk\xc3\xa1no pro %s" % (self.nazevkomplet))

			filmnazev = self.najdi('h1 itemprop="name"(.*?)/h1>', self.inhtml)
			nazevfilmu = self.najdi('>\s+(.*?)\s+<', filmnazev)
			if 'class="film-type"' in filmnazev:
				typnazev = self.najdi('<span class="film-type">(.*?)</span>', filmnazev)
				nazevfilmu += ' ' + typnazev
			nazevfilmu = self.odstraneniTagu(nazevfilmu)
			if len(nazevfilmu) > self.omezeninazvu:
				nazevfilmu = nazevfilmu[0:self.omezeninazvu] + "..."
			self["titlelabel"].setText(nazevfilmu)

			hodnoceni = self.najdi('<h2 class="average">(.*?)<', self.inhtml)
			Ratingtext = "--"
			if hodnoceni != "":
				Ratingtext = hodnoceni
				if "%" in hodnoceni:
					self.ratingstars = int(hodnoceni.replace("%",""))
					self["stars"].show()
					self["stars"].setValue(self.ratingstars)
					self["starsbg"].show()
			self["ratinglabel"].setText(Ratingtext)

			posterurl = ""
			posterurl = self.najdi('<div id="poster".*?src="(.*?)"', self.inhtml)
			if posterurl != "":
				if not "https:" in posterurl:
					posterurl = "https:" + posterurl
				velikostposteru = self.najdi('<widget name="poster".*?size="[0-9]{1,4},([0-9]{1,4})"\s', self.skin)
				if velikostposteru == '':
					velikostposteru = 180
				if velikostposteru > 360: 
					posterurl = posterurl.replace('?h180', '?h720')
				elif velikostposteru > 180:
					posterurl = posterurl.replace('?h180', '?h360')
				self["statusbar"].setText("Stahov\xc3\xa1n\xc3\xad plak\xc3\xa1tu k filmu: %s" % (posterurl))
				localfile = "/tmp/poster.jpg"
				print "[CSFD] downloading poster " + posterurl + " to " + localfile
				downloadPage(posterurl,localfile).addCallback(self.CSFDPoster).addErrback(self.fetchFailed)
			else:
				print "no jpg poster!"
				self.CSFDPoster(noPoster = True)

			Detailstext = ""
			nazevserialu = serie = ''
			serial = self.najdi('<div class="ct-general th-0 series-navigation">(.*?)</div>', self.inhtml)
			if serial:
				nazevserialu = self.najdi('<div class="content">\s+<a href="/film/.*?/">(.*?)</a>', serial)
				serie = self.najdi('</span><a href="/film/.*?/">(.*?)</a>', serial)
				nazevserialu = self.odstraneniTagu(nazevserialu)
				serie = self.odstraneniTagu(serie)
			if nazevserialu != '':
				Detailstext += 'Seri\xc3\xa1l: ' + nazevserialu
				if serie != '':
					Detailstext += ' (' + serie + ')'
				Detailstext += '\n\n'

			nazvy = self.najdi('<ul class="names">(.*?)</ul>', self.inhtml)
			if nazvy:
				vysledky = [(v2 + ' (' + v1 + ')') for v1, v2 in self.hledejVse('alt="(.*?)".*?<h3>(.*?)</h3>', nazvy)]
				for nazev in vysledky:
					Detailstext += nazev + '\n'
				Detailstext += '\n'

			zanr = self.najdi('<p class="genre">(.*?)<', self.inhtml)
			Detailstext += zanr + '\n'

			zemerokdelka = self.najdi('<p class="origin">(.*?)</p>', self.inhtml)
			zemerokdelka = zemerokdelka.replace('<span itemprop="dateCreated">', '').replace('</span>', '')
			Detailstext += zemerokdelka + '\n\n'

			vysilani = self.najdi('<ul class="relations">(.*?)</ul>', self.inhtml)
			if vysilani:
				Detailstext += 'Nejbli\xc5\xbe\xc5\xa1\xc3\xad vys\xc3\xadl\xc3\xa1n\xc3\xad v TV:\n'
				for termin in self.hledejVse('<li class="content g1">.*?>(.*?)</a>', vysilani):
					Detailstext += termin + '      '
				Detailstext += '\n\n'

			obory = ['Re\xc5\xbeie', 'P\xc5\x99edloha', 'Sc\xc3\xa9n\xc3\xa1\xc5\x99', 'Kamera','Hudba', 'Hraj\xc3\xad']
			oborytext = ""
			for obor in obory:
				jmena = self.najdi('<h4>' + obor + ':</h4>(.*?)</span>', self.inhtml)
				autori = ""
				for tvurce in self.hledejVse('<a href=".*?">(.*?)</a>', jmena):
					autori += tvurce + ", "
				if autori != "":
					autori = autori[0:len(autori)-2]
					if obor == 'Hraj\xc3\xad':
						oborytext += '\n'	
					oborytext += obor + ': ' + autori + '\n'
			Detailstext += oborytext
			if oborytext != "":
				Detailstext += '\n'

			obsahy = self.najdi('<h3>Obsah(.*?)</ul>', self.inhtml)
			for obsah, autorobsahu in self.hledejVse('<span class="dot icon.*?></span>\s+(.*?)<span class.*?>(.*?)</span>', obsahy):
				if "<a href" in autorobsahu:
					autorobsahu = "(" + self.najdi('<a href.*?>(.*?)<', autorobsahu) + ")"
				Detailstext += obsah + '   ' + autorobsahu + '\n\n'
			Detailstext = self.odstraneniTagu(Detailstext)

			Extratext = ""
			pocetkomentaru = self.najdi('<h2>Koment.*?"count">(.*?)<', self.inhtml)
			if pocetkomentaru != "" and pocetkomentaru != "(0)":
				Extratext += "Koment\xc3\xa1\xc5\x99e u\xc5\xbeivatel\xc5\xaf k filmu " + pocetkomentaru + '\n\n'
			Extratext += self.nactiKomentare(self.inhtml)
			druhastranka = self.najdi('<h2>Koment(.*?)<div class="footer">', self.inhtml)
			druhastranka = self.najdi('<span class="current">1</span>\s+<a href="(.*?)">', druhastranka)
			if 'strana-2/' in druhastranka:
				self.link2 = druhastranka
				self.komentare2 = Extratext
				self["statusbar"].setText("Stahov\xc3\xa1n\xc3\xad 2. stra\xc3\xa1nky koment\xc3\xa1\xc5\x99\xc5\xaf: %s" % (self.link2))
				localfile = "/tmp/CSFDquery3.html"
				fetchurl = "https://www.csfd.cz" + self.link2 + "?" + str(randint(1000, 9999))
				print "[CSFD] downloading query " + fetchurl + " to " + localfile
				downloadPage(fetchurl,localfile).addCallback(self.CSFDquery3).addErrback(self.fetchFailed)
			else:
				self.zobrazKomentare(Extratext)

		self["detailslabel"].setText(Detailstext)
	

	def CSFDPoster(self, noPoster = False):
		self["statusbar"].setText("Info z CSFD z\xc3\xadsk\xc3\xa1no pro: %s" % (self.nazevkomplet))
		if not noPoster:
			filename = "/tmp/poster.jpg"
		else:
			filename = resolveFilename(SCOPE_PLUGINS, "Extensions/CSFDLite/no_poster.png")
		sc = AVSwitch().getFramebufferScale()
		self.picload.setPara((self["poster"].instance.size().width(), self["poster"].instance.size().height(), sc[0], sc[1], False, 1, "#00000000"))
		self.picload.startDecode(filename)


	def paintPosterPixmapCB(self, picInfo=None):
		ptr = self.picload.getData()
		if ptr is not None:
			self["poster"].instance.setPixmap(ptr.__deref__())
			self["poster"].show()


	def createSummary(self):
		return CSFDLCDScreen


	def kontrolaUpdate(self):
		naposledy = '/tmp/CSFDLite_last_update_check'
		if (path.exists(naposledy) and path.isfile(naposledy) and access(naposledy, R_OK)):
			if time.time() - path.getmtime(naposledy) > 86400:
				kontrolovatupdate = True
			else:
				kontrolovatupdate = False
		else:
			kontrolovatupdate = True
		if kontrolovatupdate:
			open(naposledy, 'w').close()
			self.cisloverze = '/tmp/nova_verze.txt'
			downloadPage('http://ab-forum.info/ftp/csfdlite/nova_verze.txt?' + str(randint(1000, 9999)), self.cisloverze).addCallback(self.porovnaniVerze).addErrback(self.fetchFailed)


	def porovnaniVerze(self, string):
		if (path.exists(self.cisloverze) and path.isfile(self.cisloverze) and access(self.cisloverze, R_OK)):
			souborverze = open(self.cisloverze)
			novaverze = souborverze.read()
			souborverze.close()
			novaverze = self.najdi('([0-9]?[0-9].[0-9]?[0-9])', novaverze)
			if novaverze == '':
				novaverze = 0
			remove(self.cisloverze)
		else:
			novaverze = 0
			self.session.open(MessageBox, "Nen\xc3\xad k dospozici informace o verz\xc3\xadch na ab-forum", MessageBox.TYPE_INFO, timeout=30)
		if float(novaverze) > float(soucasnaverze):
			self.koncovkasouboru = str(novaverze)
			self.session.openWithCallback(self.provedeniUpdate, MessageBox, "Spustit aktualizaci pluginu CSFDLite na verzi " + novaverze + "?", MessageBox.TYPE_YESNO)


	def provedeniUpdate(self, odpoved):
		if odpoved:
			if self.kontejnerfunguje:
				downloadPage('http://ab-forum.info/ftp/csfdlite/CSFDLite' + self.koncovkasouboru + '.tar?' + str(randint(1000, 9999)), '/tmp/CSFDLite.tar').addCallback(self.rozbaleniTaru).addErrback(self.fetchFailed)
			else:
				self.session.open(MessageBox, "Nainstalovan\xc3\xa1 verze enigmy nem\xc3\xa1 objekt eConsoleAppContainer, aktualizujte plugin ru\xc4\x8dn\xc4\x9b", MessageBox.TYPE_INFO, timeout=60)


	def rozbaleniTaru(self, string):
		if self.container.execute('tar xvf /tmp/CSFDLite.tar -C /usr/lib/enigma2/python/Plugins/Extensions/CSFDLite/'):
			self.session.open(MessageBox, "Probl\xc3\xa9m s prov\xc3\xa1d\xc4\x9bn\xc3\xadm p\xc5\x99\xc3\xadkazu v containeru, aktualizace neprob\xc4\x9bhla", MessageBox.TYPE_INFO, timeout=30)


	def konecExekuce(self, exitcode):
		if exitcode == 0:
			try:
				zmeny = (open("/usr/lib/enigma2/python/Plugins/Extensions/CSFDLite/version_history.txt", "r").read())
				zmeny = self.najdi('^(.*?)\n[0-9]?[0-9].[0-9]?[0-9]', zmeny)
			except: 
				zmeny = ""
			self.session.open(MessageBox, "Aktualizace prob\xc4\x9bhla, restartujte enigmu. Zm\xc4\x9bny v posledn\xc3\xad verzi:\n\n" + zmeny, MessageBox.TYPE_INFO, timeout=30)
		else:
			self.session.open(MessageBox, "Probl\xc3\xa9m s aktualizac\xc3\xad, neexistuje tar nebo se \xc5\xa1patn\xc4\x9b st\xc3\xa1hl soubor", MessageBox.TYPE_INFO, timeout=30)


class CSFDLCDScreen(Screen):
	skin = """
	<screen position="0,0" size="132,64" title="CSFD Lite">
		<widget name="headline" position="4,0" size="128,22" font="Regular;16"/>
	</screen>"""
	def __init__(self, session, parent):
		Screen.__init__(self, session)
		self["headline"] = Label("CSFD Lite")



try:
	from Plugins.Extensions.IMDb.plugin import IMDB
	import Plugins.Extensions.IMDb.plugin
	Plugins.Extensions.IMDb.plugin.IMDB = CSFDLite
except:
	pass


def eventinfo(session, servicelist, **kwargs):
	ref = session.nav.getCurrentlyPlayingServiceReference()
	session.open(CSFDEPGSelection, ref)


def movielist(session, service, **kwargs):
	serviceHandler = eServiceCenter.getInstance()
	info = serviceHandler.info(service)
	popis = info.getInfoString(service, iServiceInformation.sDescription) or ""
	name = info and info.getName(service) or ''
	eventName = name.split(".")[0].strip()
	session.open(CSFDLite, eventName, popis)


def main(session, eventName="", popis = "", **kwargs):
	session.open(CSFDLite, eventName, popis)


def Plugins(**kwargs):
	try:
		return [PluginDescriptor(name = "CSFDLite",
				description = "CSFD Lite",
				icon = "csfd.png",
				where = PluginDescriptor.WHERE_PLUGINMENU,
				fnc = main),
				PluginDescriptor(name = "CSFDLite",
				description = "CSFD Lite",
				where = PluginDescriptor.WHERE_EVENTINFO,
				fnc = main),
				PluginDescriptor(name = "CSFDLite",
				description = "CSFD Lite",
				where = PluginDescriptor.WHERE_EXTENSIONSMENU,
				fnc = main),
				PluginDescriptor(name = "CSFDLite",
				description = "CSFD Lite",
				where = PluginDescriptor.WHERE_MOVIELIST,
				fnc = movielist)
				]
	except AttributeError:
		wherelist = [PluginDescriptor.WHERE_EXTENSIONSMENU, PluginDescriptor.WHERE_PLUGINMENU]
		return PluginDescriptor(name="CSFDLite",
				description="CSFD Lite",
				icon="csfd.png",
				where = wherelist,
				fnc=main)
